set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Figure 2

use $path_in\KLEMS_b2008_clean, clear
		
	preserve
		keep if code=="TOT" /*keep aggregate data: this total excludes the industries we remove from the analysis (see readme.pdf)*/
		keep country year laborshare
		save $path_temp\temp, replace
	restore
	
	drop if code=="TOT" /*keep sector-specific data*/
	sum weight_VA
	collapse (mean) laborshare [w=weight_VA], by(country year)
	rename laborshare laborshare_w
	
	merge 1:1 country year using $path_temp\temp
	drop _
	
	label var laborshare_w "Reweighted labor share"
	label var laborshare "Labor share"

	*Figure 2
	graph twoway (line laborshare year, lcolor(navy) by(country, noiytitles )) ///
				(line laborshare_w year, lcolor(red) bgcolor(white) plotregion(color(white)) graphregion(color(white))), /// 
				by(country, style(combine) noiytitles bgcolor(white) plotregion(color(white)) graphregion(color(white))  ///
				note("Labor share is labor compensation over value added x 100%. Reweighted labor share is the average of industry labor shares weighted" ///
				"by time-averaged industry value added shares. Figures are for the total economy, excluding agriculture, public administration," /// 
				"private households, and extraterritorial organizations.", size(vsmall)) )
				
	graph export "$path_out\Fig2.eps", as(eps) replace		

	
*Erase temporary file
	cap erase $path_temp\temp.dta
